/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.optifine.shaders.DrawBuffers;
import net.optifine.shaders.FixedFramebuffer;
import net.optifine.shaders.FlipTextures;
import net.optifine.shaders.GlState;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.Shaders;
import net.optifine.util.ArrayUtils;
import net.optifine.util.CompoundIntKey;
import net.optifine.util.CompoundKey;
import net.optifine.util.DynamicDimension;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class ShadersFramebuffer {
    private String name;
    private int width;
    private int height;
    private int usedColorBuffers;
    private int usedDepthBuffers;
    private int maxDrawBuffers;
    private boolean[] depthFilterNearest;
    private boolean[] depthFilterHardware;
    private boolean[] colorFilterNearest;
    private DynamicDimension[] colorBufferSizes;
    private int[] buffersFormat;
    private int[] colorTextureUnits;
    private int[] depthTextureUnits;
    private int[] colorImageUnits;
    private int glFramebuffer;
    private FlipTextures colorTexturesFlip;
    private IntBuffer depthTextures;
    private final DrawBuffers drawBuffers;
    private DrawBuffers activeDrawBuffers;
    private int[] drawColorTextures;
    private int[] drawColorTexturesMap;
    private boolean[] dirtyColorTextures;
    private Map<CompoundKey, FixedFramebuffer> fixedFramebuffers = new HashMap();

    public ShadersFramebuffer(String name, int width, int height, int usedColorBuffers, int usedDepthBuffers, int maxDrawBuffers, boolean[] depthFilterNearest, boolean[] depthFilterHardware, boolean[] colorFilterNearest, DynamicDimension[] colorBufferSizes, int[] buffersFormat, int[] colorTextureUnits, int[] depthTextureUnits, int[] colorImageUnits, DrawBuffers drawBuffers) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.usedColorBuffers = usedColorBuffers;
        this.usedDepthBuffers = usedDepthBuffers;
        this.maxDrawBuffers = maxDrawBuffers;
        this.depthFilterNearest = depthFilterNearest;
        this.depthFilterHardware = depthFilterHardware;
        this.colorFilterNearest = colorFilterNearest;
        this.colorBufferSizes = colorBufferSizes;
        this.buffersFormat = buffersFormat;
        this.colorTextureUnits = colorTextureUnits;
        this.depthTextureUnits = depthTextureUnits;
        this.colorImageUnits = colorImageUnits;
        this.drawBuffers = drawBuffers;
    }

    public void setup() {
        int status;
        Dimension dim;
        int filter;
        int i;
        if (this.exists()) {
            this.delete();
        }
        this.colorTexturesFlip = new FlipTextures(this.name + "ColorTexturesFlip", this.usedColorBuffers);
        this.depthTextures = BufferUtils.createIntBuffer((int)this.usedDepthBuffers);
        this.drawColorTextures = new int[this.usedColorBuffers];
        this.drawColorTexturesMap = new int[this.usedColorBuffers];
        this.dirtyColorTextures = new boolean[this.maxDrawBuffers];
        Arrays.fill(this.drawColorTextures, 0);
        Arrays.fill(this.drawColorTexturesMap, -1);
        Arrays.fill(this.dirtyColorTextures, false);
        for (i = 0; i < this.drawBuffers.limit(); ++i) {
            this.drawBuffers.put(i, 36064 + i);
        }
        this.glFramebuffer = GL30.glGenFramebuffers();
        this.bindFramebuffer();
        GL30.glDrawBuffers((int)0);
        GL30.glReadBuffer((int)0);
        GL30.glGenTextures((IntBuffer)this.depthTextures.clear().limit(this.usedDepthBuffers));
        this.colorTexturesFlip.clear().limit(this.usedColorBuffers).genTextures();
        this.depthTextures.position(0);
        this.colorTexturesFlip.position(0);
        for (i = 0; i < this.usedDepthBuffers; ++i) {
            GlStateManager._bindTexture((int)this.depthTextures.get(i));
            GL30.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL30.glTexParameteri((int)3553, (int)10243, (int)33071);
            filter = this.depthFilterNearest[i] ? 9728 : 9729;
            GL30.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL30.glTexParameteri((int)3553, (int)10240, (int)filter);
            if (this.depthFilterHardware[i]) {
                GL30.glTexParameteri((int)3553, (int)34892, (int)34894);
            }
            GL30.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.width, (int)this.height, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
        }
        this.setFramebufferTexture2D(36160, 36096, 3553, this.depthTextures.get(0), 0);
        Shaders.checkGLError((String)("FBS " + this.name + " depth"));
        for (i = 0; i < this.usedColorBuffers; ++i) {
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(i));
            GL30.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL30.glTexParameteri((int)3553, (int)10243, (int)33071);
            filter = this.colorFilterNearest[i] ? 9728 : 9729;
            GL30.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL30.glTexParameteri((int)3553, (int)10240, (int)filter);
            dim = this.colorBufferSizes[i] != null ? this.colorBufferSizes[i].getDimension(this.width, this.height) : new Dimension(this.width, this.height);
            GL30.glTexImage2D((int)3553, (int)0, (int)this.buffersFormat[i], (int)dim.width, (int)dim.height, (int)0, (int)Shaders.getPixelFormat((int)this.buffersFormat[i]), (int)33639, (ByteBuffer)null);
            this.setFramebufferTexture2D(36160, 36064 + i, 3553, this.colorTexturesFlip.getA(i), 0);
            Shaders.checkGLError((String)("FBS " + this.name + " colorA"));
        }
        for (i = 0; i < this.usedColorBuffers; ++i) {
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getB(i));
            GL30.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL30.glTexParameteri((int)3553, (int)10243, (int)33071);
            filter = this.colorFilterNearest[i] ? 9728 : 9729;
            GL30.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL30.glTexParameteri((int)3553, (int)10240, (int)filter);
            dim = this.colorBufferSizes[i] != null ? this.colorBufferSizes[i].getDimension(this.width, this.height) : new Dimension(this.width, this.height);
            GL30.glTexImage2D((int)3553, (int)0, (int)this.buffersFormat[i], (int)dim.width, (int)dim.height, (int)0, (int)Shaders.getPixelFormat((int)this.buffersFormat[i]), (int)33639, (ByteBuffer)null);
            Shaders.checkGLError((String)("FBS " + this.name + " colorB"));
        }
        GlStateManager._bindTexture((int)0);
        if (this.usedColorBuffers > 0) {
            this.setDrawBuffers(this.drawBuffers);
            GL30.glReadBuffer((int)0);
        }
        if ((status = GL30.glCheckFramebufferStatus((int)36160)) != 36053) {
            Shaders.printChatAndLogError((String)("[Shaders] Error creating framebuffer: " + this.name + ", status: " + status));
            return;
        }
        SMCLog.info((String)("Framebuffer created: " + this.name));
    }

    public void delete() {
        if (this.glFramebuffer != 0) {
            GL30.glDeleteFramebuffers((int)this.glFramebuffer);
            this.glFramebuffer = 0;
        }
        if (this.colorTexturesFlip != null) {
            this.colorTexturesFlip.deleteTextures();
            this.colorTexturesFlip = null;
        }
        if (this.depthTextures != null) {
            GlStateManager.deleteTextures((IntBuffer)this.depthTextures);
            this.depthTextures = null;
        }
        this.drawBuffers.position(0).fill(0);
        for (FixedFramebuffer ff : this.fixedFramebuffers.values()) {
            ff.delete();
        }
        this.fixedFramebuffers.clear();
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getGlFramebuffer() {
        return this.glFramebuffer;
    }

    public boolean exists() {
        return this.glFramebuffer != 0;
    }

    public void bindFramebuffer() {
        GlState.bindFramebuffer((ShadersFramebuffer)this);
    }

    public void setColorTextures(boolean main) {
        for (int i = 0; i < this.usedColorBuffers; ++i) {
            this.setFramebufferTexture2D(36160, 36064 + i, 3553, this.colorTexturesFlip.get(main, i), 0);
        }
    }

    public void setDepthTexture() {
        this.setFramebufferTexture2D(36160, 36096, 3553, this.depthTextures.get(0), 0);
    }

    public void setColorBuffersFiltering(int minFilter, int magFilter) {
        GlStateManager._activeTexture((int)33984);
        for (int i = 0; i < this.usedColorBuffers; ++i) {
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(i));
            GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getB(i));
            GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        }
        GlStateManager._bindTexture((int)0);
    }

    public void setFramebufferTexture2D(int target, int attachment, int texTarget, int texture, int level) {
        int colorIndex = attachment - 36064;
        if (this.isColorBufferIndex(colorIndex)) {
            if (this.colorBufferSizes[colorIndex] != null) {
                if (this.isColorExtendedIndex(colorIndex)) {
                    return;
                }
                texture = 0;
            }
            this.drawColorTextures[colorIndex] = texture;
            if (colorIndex >= this.maxDrawBuffers) {
                int indexMapped = this.drawColorTexturesMap[colorIndex];
                if (!this.isDrawBufferIndex(indexMapped)) {
                    return;
                }
                attachment = 36064 + indexMapped;
            }
        }
        this.bindFramebuffer();
        GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)texTarget, (int)texture, (int)level);
    }

    public boolean isColorBufferIndex(int index) {
        return index >= 0 && index < this.usedColorBuffers;
    }

    public boolean isColorExtendedIndex(int index) {
        return index >= this.maxDrawBuffers && index < this.usedColorBuffers;
    }

    public boolean isDrawBufferIndex(int index) {
        return index >= 0 && index < this.maxDrawBuffers;
    }

    private void setDrawColorTexturesMap(int[] newColorTexturesMap) {
        int i;
        this.bindFramebuffer();
        for (i = 0; i < this.maxDrawBuffers; ++i) {
            if (!this.dirtyColorTextures[i]) continue;
            int texture = this.drawColorTextures[i];
            GL30.glFramebufferTexture2D((int)36160, (int)(36064 + i), (int)3553, (int)texture, (int)0);
            this.dirtyColorTextures[i] = false;
        }
        this.drawColorTexturesMap = newColorTexturesMap;
        for (i = this.maxDrawBuffers; i < this.drawColorTexturesMap.length; ++i) {
            int ai = this.drawColorTexturesMap[i];
            if (ai < 0) continue;
            int texture = this.drawColorTextures[i];
            GL30.glFramebufferTexture2D((int)36160, (int)(36064 + ai), (int)3553, (int)texture, (int)0);
            this.dirtyColorTextures[ai] = true;
        }
    }

    public void setDrawBuffers(DrawBuffers drawBuffersIn) {
        if (drawBuffersIn == null) {
            drawBuffersIn = Shaders.drawBuffersNone;
        }
        this.setDrawColorTexturesMap(drawBuffersIn.getAttachmentMappings());
        this.activeDrawBuffers = drawBuffersIn;
        this.bindFramebuffer();
        GL30.glDrawBuffers((IntBuffer)drawBuffersIn.getGlDrawBuffers());
        Shaders.checkGLError((String)"setDrawBuffers");
    }

    public void setDrawBuffers() {
        this.setDrawBuffers(this.drawBuffers);
    }

    public DrawBuffers getDrawBuffers() {
        return this.activeDrawBuffers;
    }

    public void bindDepthTextures(int[] depthTextureImageUnits) {
        for (int i = 0; i < this.usedDepthBuffers; ++i) {
            GlStateManager._activeTexture((int)(33984 + depthTextureImageUnits[i]));
            GlStateManager._bindTexture((int)this.depthTextures.get(i));
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void bindColorTextures(int startColorBuffer) {
        for (int i = startColorBuffer; i < this.usedColorBuffers; ++i) {
            GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[i]));
            GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(i));
            this.bindColorImage(i, true);
        }
    }

    public void bindColorImages(boolean main) {
        if (this.colorImageUnits == null) {
            return;
        }
        for (int i = 0; i < this.usedColorBuffers; ++i) {
            this.bindColorImage(i, main);
        }
    }

    public void bindColorImage(int index, boolean main) {
        if (this.colorImageUnits == null) {
            return;
        }
        if (index >= 0 && index < this.colorImageUnits.length) {
            int imageFormat = Shaders.getImageFormat((int)this.buffersFormat[index]);
            GlStateManager.bindImageTexture((int)this.colorImageUnits[index], (int)this.colorTexturesFlip.get(main, index), (int)0, (boolean)false, (int)0, (int)35002, (int)imageFormat);
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void generateDepthMipmaps(boolean[] depthMipmapEnabled) {
        for (int i = 0; i < this.usedDepthBuffers; ++i) {
            if (!depthMipmapEnabled[i]) continue;
            GlStateManager._activeTexture((int)(33984 + this.depthTextureUnits[i]));
            GlStateManager._bindTexture((int)this.depthTextures.get(i));
            GL30.glGenerateMipmap((int)3553);
            GL30.glTexParameteri((int)3553, (int)10241, (int)(this.depthFilterNearest[i] ? 9984 : 9987));
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void generateColorMipmaps(boolean main, boolean[] colorMipmapEnabled) {
        for (int i = 0; i < this.usedColorBuffers; ++i) {
            if (!colorMipmapEnabled[i]) continue;
            GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[i]));
            GlStateManager._bindTexture((int)this.colorTexturesFlip.get(main, i));
            GL30.glGenerateMipmap((int)3553);
            GL30.glTexParameteri((int)3553, (int)10241, (int)(this.colorFilterNearest[i] ? 9984 : 9987));
        }
        GlStateManager._activeTexture((int)33984);
    }

    public void genCompositeMipmap(int compositeMipmapSetting) {
        if (Shaders.hasGlGenMipmap) {
            for (int i = 0; i < this.usedColorBuffers; ++i) {
                if ((compositeMipmapSetting & 1 << i) == 0) continue;
                GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[i]));
                GL30.glTexParameteri((int)3553, (int)10241, (int)9987);
                GL30.glGenerateMipmap((int)3553);
            }
            GlStateManager._activeTexture((int)33984);
        }
    }

    public void flipColorTextures(boolean[] toggleColorTextures) {
        for (int i = 0; i < this.colorTexturesFlip.limit(); ++i) {
            if (!toggleColorTextures[i]) continue;
            this.flipColorTexture(i);
        }
    }

    public void flipColorTexture(int index) {
        this.colorTexturesFlip.flip(index);
        GlStateManager._activeTexture((int)(33984 + this.colorTextureUnits[index]));
        GlStateManager._bindTexture((int)this.colorTexturesFlip.getA(index));
        this.bindColorImage(index, true);
        this.setFramebufferTexture2D(36160, 36064 + index, 3553, this.colorTexturesFlip.getB(index), 0);
        GlStateManager._activeTexture((int)33984);
    }

    public void clearColorBuffers(boolean[] buffersClear, Vector4f[] clearColors) {
        for (int i = 0; i < this.usedColorBuffers; ++i) {
            if (!buffersClear[i]) continue;
            Vector4f col = clearColors[i];
            if (col != null) {
                GL30.glClearColor((float)col.x(), (float)col.y(), (float)col.z(), (float)col.w());
            }
            if (this.colorBufferSizes[i] != null) {
                if (this.colorTexturesFlip.isChanged(i)) {
                    this.clearColorBufferFixedSize(i, false);
                }
                this.clearColorBufferFixedSize(i, true);
                continue;
            }
            if (this.colorTexturesFlip.isChanged(i)) {
                this.setFramebufferTexture2D(36160, 36064 + i, 3553, this.colorTexturesFlip.getB(i), 0);
                this.setDrawBuffers(Shaders.drawBuffersColorAtt[i]);
                GL30.glClear((int)16384);
                this.setFramebufferTexture2D(36160, 36064 + i, 3553, this.colorTexturesFlip.getA(i), 0);
            }
            this.setDrawBuffers(Shaders.drawBuffersColorAtt[i]);
            GL30.glClear((int)16384);
        }
    }

    private void clearColorBufferFixedSize(int i, boolean main) {
        Dimension dim = this.colorBufferSizes[i].getDimension(this.width, this.height);
        if (dim == null) {
            return;
        }
        FixedFramebuffer ff = this.getFixedFramebuffer(dim.width, dim.height, Shaders.drawBuffersColorAtt[i], main);
        ff.bindFramebuffer();
        GL30.glClear((int)16384);
    }

    public void clearDepthBuffer(Vector4f col) {
        this.setFramebufferTexture2D(36160, 36096, 3553, this.depthTextures.get(0), 0);
        GL30.glClearColor((float)col.x(), (float)col.y(), (float)col.z(), (float)col.w());
        GL30.glClear((int)256);
    }

    public String toString() {
        return this.name + ", width: " + this.width + ", height: " + this.height + ", usedColorBuffers: " + this.usedColorBuffers + ", usedDepthBuffers: " + this.usedDepthBuffers + ", maxDrawBuffers: " + this.maxDrawBuffers;
    }

    public FixedFramebuffer getFixedFramebuffer(int width, int height, DrawBuffers dbs2, boolean main) {
        IntBuffer glDbs = dbs2.getGlDrawBuffers();
        int dbsLen = dbs2.limit();
        int[] glTexs = new int[dbsLen];
        int[] glAtts = new int[dbsLen];
        for (int i = 0; i < glTexs.length; ++i) {
            int att = dbs2.get(i);
            int ix = att - 36064;
            if (!this.isColorBufferIndex(ix)) continue;
            glTexs[i] = this.colorTexturesFlip.get(main, ix);
            glAtts[i] = glDbs.get(i);
        }
        CompoundKey key = new CompoundKey((Object)new CompoundIntKey(glTexs), (Object)new CompoundIntKey(glAtts));
        FixedFramebuffer ff = (FixedFramebuffer)this.fixedFramebuffers.get(key);
        if (ff == null) {
            String fixedName = this.name + ", [" + ArrayUtils.arrayToString((int[])glTexs) + "], [" + ArrayUtils.arrayToString((int[])glAtts) + "]";
            ff = new FixedFramebuffer(fixedName, width, height, glTexs, glAtts, this.depthFilterNearest[0], this.depthFilterHardware[0]);
            ff.setup();
            this.fixedFramebuffers.put(key, ff);
        }
        return ff;
    }
}

