/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.TooltipProviderOptions;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.util.StrUtils;

public class TooltipProviderShaderOptions
extends TooltipProviderOptions {
    public String[] getTooltipLines(exe btn, int width) {
        if (!(btn instanceof GuiButtonShaderOption)) {
            return null;
        }
        GuiButtonShaderOption btnSo = (GuiButtonShaderOption)btn;
        ShaderOption so2 = btnSo.getShaderOption();
        String[] lines = this.makeTooltipLines(so2, width);
        return lines;
    }

    private String[] makeTooltipLines(ShaderOption so2, int width) {
        String name = so2.getNameText();
        String desc = Config.normalize((String)so2.getDescriptionText()).trim();
        String[] descs = this.splitDescription(desc);
        evm settings = Config.getGameSettings();
        String id = null;
        if (!name.equals(so2.getName()) && settings.m) {
            id = "\u00a78" + Lang.get((String)"of.general.id") + ": " + so2.getName();
        }
        String source = null;
        if (so2.getPaths() != null && settings.m) {
            source = "\u00a78" + Lang.get((String)"of.general.from") + ": " + Config.arrayToString((Object[])so2.getPaths());
        }
        String def = null;
        if (so2.getValueDefault() != null && settings.m) {
            String defVal = so2.isEnabled() ? so2.getValueText(so2.getValueDefault()) : Lang.get((String)"of.general.ambiguous");
            def = "\u00a78" + Lang.getDefault() + ": " + defVal;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(name);
        list.addAll(Arrays.asList(descs));
        if (id != null) {
            list.add(id);
        }
        if (source != null) {
            list.add(source);
        }
        if (def != null) {
            list.add(def);
        }
        String[] lines = this.makeTooltipLines(width, list);
        return lines;
    }

    private String[] splitDescription(String desc) {
        if (desc.length() <= 0) {
            return new String[0];
        }
        desc = StrUtils.removePrefix((String)desc, (String)"//");
        String[] descs = desc.split("\\. ");
        for (int i = 0; i < descs.length; ++i) {
            descs[i] = "- " + descs[i].trim();
            descs[i] = StrUtils.removeSuffix((String)descs[i], (String)".");
        }
        return descs;
    }

    private String[] makeTooltipLines(int width, List<String> args) {
        ews fr = Config.getMinecraft().h;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg == null || arg.length() <= 0) continue;
            vt argComp = vf.b((String)arg);
            List parts = fr.b().b((vk)argComp, width, wc.a);
            for (vk part : parts) {
                list.add(part.getString());
            }
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }
}

