/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.CustomSkyLayer;
import net.optifine.render.Blender;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.Shaders;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import net.optifine.util.WorldUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies();
    }

    private static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "optifine/sky/world";
        int lastWorldId = -1;
        for (int w = 0; w < wsls.length; ++w) {
            String worldPrefix = prefix + w;
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i = 0; i < 1000; ++i) {
                String path = worldPrefix + "/sky" + i + ".properties";
                int countMissing = 0;
                try {
                    ahg locPath = new ahg(path);
                    InputStream in = Config.getResourceStream((ahg)locPath);
                    if (in == null && ++countMissing > 10) break;
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in);
                    in.close();
                    Config.dbg((String)("CustomSky properties: " + path));
                    String defSource = i + ".png";
                    CustomSkyLayer sl = new CustomSkyLayer((Properties)props, defSource);
                    if (!sl.isValid(path)) continue;
                    String srcPath = StrUtils.addSuffixCheck((String)sl.source, (String)".png");
                    ahg locSource = new ahg(srcPath);
                    gdy tex = TextureUtils.getTexture((ahg)locSource);
                    if (tex == null) {
                        Config.log((String)("CustomSky: Texture not found: " + locSource));
                        continue;
                    }
                    sl.textureId = tex.a();
                    listSkyLayers.add(sl);
                    in.close();
                    continue;
                }
                catch (FileNotFoundException e) {
                    if (++countMissing <= 10) continue;
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w] = sls;
            lastWorldId = w;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i = 0; i < wslsTrim.length; ++i) {
            wslsTrim[i] = wsls[i];
        }
        return wslsTrim;
    }

    public static void renderSky(ctp world, eqb matrixStackIn, float partialTicks) {
        int dimId;
        if (worldSkyLayers == null) {
            return;
        }
        if (Config.isShaders()) {
            Shaders.setRenderStage((RenderStage)RenderStage.CUSTOM_SKY);
        }
        if ((dimId = WorldUtils.getDimensionId((ctp)world)) < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.Y();
        int timeOfDay = (int)(time % 24000L);
        float celestialAngle = world.f(partialTicks);
        float rainStrength = world.d(partialTicks);
        float thunderStrength = world.b(partialTicks);
        if (rainStrength > 0.0f) {
            thunderStrength /= rainStrength;
        }
        for (int i = 0; i < sls.length; ++i) {
            CustomSkyLayer sl = sls[i];
            if (!sl.isActive(world, timeOfDay)) continue;
            sl.render(world, matrixStackIn, timeOfDay, celestialAngle, rainStrength, thunderStrength);
        }
        float rainBrightness = 1.0f - rainStrength;
        Blender.clearBlend((float)rainBrightness);
    }

    public static boolean hasSkyLayers(ctp world) {
        if (worldSkyLayers == null) {
            return false;
        }
        int dimId = WorldUtils.getDimensionId((ctp)world);
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }
}

